/*
 * Rhythm Science Sound
 * introduction to electronic sound synthesis with Arduino
 * rhythmsciencesound.com
 */
 //This names the pins that will be in use.
 const int SPEAKER = 9;
 const int PITCH_KNOB1 = A0;
 const int PITCH_KNOB2 = A1;
 const int PITCH_KNOB3 = A2;
 const int PITCH_KNOB4 = A3;
 const int TEMPO_KNOB = A4;
 const int MACRO_PITCH_KNOB = A5;
 const int TRIGGER1 = 2;
 const int TRIGGER2 = 3;
 const int TRIGGER3 = 4;
 const int TRIGGER4 = 5;
 const int TRIGGER5 = 6;
 const int LEDCLOCK = 13;
 
 //Here are some variables that will be modified.
 int trigger1_state;
 int trigger2_state;
 int trigger3_state;
 int trigger4_state;  
 int trigger5_state;
 int frequency1;
 int frequency2;
 int frequency3;
 int frequency4;
 int pitch1;
 int pitch2;
 int pitch3;
 int pitch4;

// Frequences for each note are taken from toneMelody
#define NOTE_B0  31
#define NOTE_C1  33
#define NOTE_CS1 35
#define NOTE_D1  37
#define NOTE_DS1 39
#define NOTE_E1  41
#define NOTE_F1  44
#define NOTE_FS1 46
#define NOTE_G1  49
#define NOTE_GS1 52
#define NOTE_A1  55
#define NOTE_AS1 58
#define NOTE_B1  62
#define NOTE_C2  65
#define NOTE_CS2 69
#define NOTE_D2  73
#define NOTE_DS2 78
#define NOTE_E2  82
#define NOTE_F2  87
#define NOTE_FS2 93
#define NOTE_G2  98
#define NOTE_GS2 104
#define NOTE_A2  110
#define NOTE_AS2 117
#define NOTE_B2  123
#define NOTE_C3  131
#define NOTE_CS3 139
#define NOTE_D3  147
#define NOTE_DS3 156
#define NOTE_E3  165
#define NOTE_F3  175
#define NOTE_FS3 185
#define NOTE_G3  196
#define NOTE_GS3 208
#define NOTE_A3  220
#define NOTE_AS3 233
#define NOTE_B3  247
#define NOTE_C4  262
#define NOTE_CS4 277
#define NOTE_D4  294
#define NOTE_DS4 311
#define NOTE_E4  330
#define NOTE_F4  349
#define NOTE_FS4 370
#define NOTE_G4  392
#define NOTE_GS4 415
#define NOTE_A4  440
#define NOTE_AS4 466
#define NOTE_B4  494
#define NOTE_C5  523
#define NOTE_CS5 554
#define NOTE_D5  587
#define NOTE_DS5 622
#define NOTE_E5  659
#define NOTE_F5  698
#define NOTE_FS5 740
#define NOTE_G5  784
#define NOTE_GS5 831
#define NOTE_A5  880
#define NOTE_AS5 932
#define NOTE_B5  988
#define NOTE_C6  1047
#define NOTE_CS6 1109
#define NOTE_D6  1175
#define NOTE_DS6 1245
#define NOTE_E6  1319
#define NOTE_F6  1397
#define NOTE_FS6 1480
#define NOTE_G6  1568
#define NOTE_GS6 1661
#define NOTE_A6  1760
#define NOTE_AS6 1865
#define NOTE_B6  1976
#define NOTE_C7  2093
#define NOTE_CS7 2217
#define NOTE_D7  2349
#define NOTE_DS7 2489
#define NOTE_E7  2637
#define NOTE_F7  2794
#define NOTE_FS7 2960
#define NOTE_G7  3136
#define NOTE_GS7 3322
#define NOTE_A7  3520
#define NOTE_AS7 3729
#define NOTE_B7  3951
#define NOTE_C8  4186
#define NOTE_CS8 4435
#define NOTE_D8  4699
#define NOTE_DS8 4978

// Provide a list of the notes we want to be able play
int notes[] = {
 NOTE_B0,
 NOTE_C1, NOTE_CS1, NOTE_D1, NOTE_DS1, NOTE_E1, NOTE_F1, NOTE_FS1, NOTE_G1, NOTE_GS1, NOTE_A1, NOTE_AS1, NOTE_B1,
 NOTE_C2, NOTE_CS2, NOTE_D2, NOTE_DS2, NOTE_E2, NOTE_F2, NOTE_FS2, NOTE_G2, NOTE_GS2, NOTE_A2, NOTE_AS2, NOTE_B2,
 NOTE_C3, NOTE_CS3, NOTE_D3, NOTE_DS3, NOTE_E3, NOTE_F3, NOTE_FS3, NOTE_G3, NOTE_GS3, NOTE_A3, NOTE_AS3, NOTE_B3,
 NOTE_C4, NOTE_CS4, NOTE_D4, NOTE_DS4, NOTE_E4, NOTE_F4, NOTE_FS4, NOTE_G4, NOTE_GS4, NOTE_A4, NOTE_AS4, NOTE_B4,
 NOTE_C5, NOTE_CS5, NOTE_D5, NOTE_DS5, NOTE_E5, NOTE_F5, NOTE_FS5, NOTE_G5, NOTE_GS5, NOTE_A5, NOTE_AS5, NOTE_B5,
 NOTE_C6, NOTE_CS6, NOTE_D6, NOTE_DS6, NOTE_E6, NOTE_F6, NOTE_FS6, NOTE_G6, NOTE_GS6, NOTE_A6, NOTE_AS6, NOTE_B6,
 NOTE_C7, NOTE_CS7, NOTE_D7, NOTE_DS7, NOTE_E7, NOTE_F7, NOTE_FS7, NOTE_G7, NOTE_GS7, NOTE_A7, NOTE_AS7, NOTE_B7,
 NOTE_C8, NOTE_CS8, NOTE_D8, NOTE_DS8
};
int numNotes;
int playingNote;
unsigned long startMillis;
unsigned long currentMillis;
const unsigned long period = 0; //the value is a number of milliseconds, 

 
void setup() {
  // put your setup code here, to run once:
//this sets the digital pin as an input, and applies the internal
//pullup resistor to keep the pin in a HIGH state. It will be triggered
//by a LOW signal from the TRIGGER button press.  
pinMode(TRIGGER1, INPUT_PULLUP);
pinMode(TRIGGER2, INPUT_PULLUP);
pinMode(TRIGGER3, INPUT_PULLUP);
pinMode(TRIGGER4, INPUT_PULLUP);
pinMode(TRIGGER5, INPUT_PULLUP);
pinMode(LEDCLOCK, OUTPUT);

 // This is a programming trick to work out the number of notes we've listed
numNotes = sizeof(notes)/sizeof(notes[0]);
playingNote=0;
startMillis = millis();  //initial start time for our time period
}

void loop() {
  // put your main code here, to run repeatedly:
digitalWrite(LEDCLOCK, LOW);
  
int macroPitchPot = analogRead(MACRO_PITCH_KNOB);
int macroPitch= map(macroPitchPot, 0, 1023, 0, numNotes-1);
//int macroPitch= map(macroPitchPot, 0, 1023, 0, notes-1);  //bbc- use this weird "incorrect" mapping for MacroPitch to add even more chaos to the edges of our pitch ranges. What a fun useful "bug"
int potReading = analogRead (PITCH_KNOB1+playingNote);
int globalPitch = playingNote + macroPitch;
int pitch = map(potReading, 0, 1023, 0, globalPitch);

trigger1_state = digitalRead(TRIGGER1);
trigger2_state = digitalRead(TRIGGER2);
trigger3_state = digitalRead(TRIGGER3);
trigger4_state = digitalRead(TRIGGER4);
trigger5_state = digitalRead(TRIGGER5);
  if (playingNote >= 4) {
    playingNote = 0;
  }
 if (trigger1_state == LOW ) {
  pitch = pitch;
  tone (SPEAKER, notes[pitch]);
 }
 if(trigger2_state == LOW){
  pitch = pitch+1;
  tone (SPEAKER, notes[pitch]);
 }
  if(trigger3_state == LOW){
  pitch = pitch+2;
  tone (SPEAKER, notes[pitch]);
 }
  if(trigger4_state == LOW){
  pitch = pitch+3;
  tone (SPEAKER, notes[pitch]);
 }
  if(trigger5_state == LOW){
  pitch = pitch+4;
  tone (SPEAKER, notes[pitch]);
 }
  if(trigger1_state==HIGH && trigger2_state==HIGH && trigger3_state==HIGH && trigger4_state==HIGH && trigger5_state==HIGH ){
playingNote = 0;
  noTone(SPEAKER);
}

 int bpm = analogRead (TEMPO_KNOB);
   int period = map(bpm, 0, 1023,1000, 5);
currentMillis = millis();
if (currentMillis - startMillis >= period)  //test whether the period has elapsed
  {
        playingNote++;
        digitalWrite(LEDCLOCK, HIGH);
        startMillis = currentMillis;  //IMPORTANT to save the start time for the next sequence round.

}

}
